<?php
	error_reporting(E_ALL);
	ini_set('display_errors', '1');
/*
 * Plugin Name: Mortgage Amortization Calculator
 * Version: 1.0
 * Plugin URI: https://www.mortgage-amortization.info/mortgage-calculator-for-website
 * Description: Mortgage Amortization Calculator Plugin by <a href="https://www.mortgage-amortization.info/">Mortgage Amortization</a>.
 * Author: digitron
 * Author URI: https://www.mortgage-amortization.info/
 */
add_action('widgets_init','MACalcWidget');

function MACalcWidget() {
	register_widget('MACacl');
}

class MACacl extends WP_Widget {

	function MACacl() {
		$widget_ops = array( 'classname' => 'macalc', 'description' => __('Mortgage Calculator widget', 'macalc') );
		$control_ops = array( 'width' => '100%', 'height' => 350, 'id_base' => 'macalc-widget' );
		$this->WP_Widget( 'macalc-widget', __('Mortgage Calculator', 'macalc'), $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters('widget_title', $instance['title'] );
		$currency = $instance['currency'];
		echo $before_widget;
		if ( $title )
		echo $before_title . $title . $after_title;
		echo '<link type="text/css" rel="stylesheet" href="' . get_bloginfo('wpurl') . '/wp-content/plugins/macalc/css/style.css" />';
    echo '<div id="macalc">';
		echo '  <form name="madata" action="javascript: return false;">';
		echo '    <fieldset>';
		echo '      <div>';
		echo '        <label for="hval">Home value:</label>';
		echo '        <input type="text" name="hval" id="hval" value="' . $currency . '" onchange="CalculateLoan();" onFocus="clearText(this);" />';
		echo '      </div>';
		echo '      <div>';
		echo '        <label for="dpay">Down payment:</label>';
		echo '        <input type="text" name="dpay" id="dpay" value="%" onchange="CalculateLoan();" onFocus="clearText(this);" />';
		echo '      </div>';
		echo '      <div>';
		echo '        <label for="lamo">Loan amount:</label>';
		echo '        <input type="text" name="lamo" id="lamo" class="req" onchange="Calculate();" />';
		echo '      </div>';
		echo '      <div>';
		echo '        <label for="irat">Interest rate:</label>';
		echo '        <input type="text" name="irat" id="irat" class="req" value="%" onchange="Calculate();" onFocus="clearText(this);" />';
		echo '      </div>';
		echo '      <div>';
		echo '        <label for="llen">Loan length:</label>';
		echo '        <input type="text" name="llen" id="llen" class="req" onchange="Calculate();" />';
		echo '      </div>';
		echo '      <div>';
		echo '        <label for="pper">Pay periodicity:</label>';
		echo '        <select name="pper" id="pper" class="selects" onchange="Calculate();">';
		echo '          <option value="52">weekly</option>';
		echo '          <option value="26">bi-weekly</option>';
		echo '          <option value="12" selected="selected">monthly</option>';
		echo '          <option value="6">bi-monthly</option>';
		echo '          <option value="4">quarterly</option>';
		echo '          <option value="2">semi-annually</option>';
		echo '          <option value="1">annually</option>';
		echo '        </select>';
		echo '      </div>';
		echo '      <div class="right">';
		echo '        <input type="submit" value="calculate" class="calculate" onclick="Calculate();" />';
		echo '      </div>';
		echo '      <div>';
		echo '        <label for="paymentNum">Number of periods:</label>';
		echo '        <input type="text" name="paymentNum" id="paymentNum" />';
		echo '      </div>';
		echo '      <div>';
		echo '        <label for="periodicalPayment">Periodic Payment:</label>';
		echo '        <input type="text" name="periodicalPayment" id="periodicalPayment" />';
		echo '      </div>';
		echo '      <p>View <a href="https://www.mortgage-amortization.info/" target="_blank">mortgage amortization</a> schedule.</p>';
		echo '    </fieldset>';
		echo '  </form>';
    echo '<script language="JavaScript">';
		echo 'function CalculateLoan() {';
		echo '	mortgageHomeValue = document.madata.hval.value;';
		echo '	mortgageDownPayment = document.madata.dpay.value;';
		echo '	if (mortgageHomeValue != "" && mortgageDownPayment != "" && mortgageDownPayment != "%") {';
		echo '		mortgageAmount = mortgageHomeValue - (mortgageHomeValue * (mortgageDownPayment / 100));';
		echo '	}';
		echo '	document.madata.lamo.value = mortgageAmount;';
		echo '}';
    echo 'function Calculate() {';
    echo '	loanAmount = document.madata.lamo.value;';
    echo '	loanInterest = document.madata.irat.value/100;';
    echo '	loanLength = document.madata.llen.value;';
    echo '	loanPeriods = document.madata.pper.value;';
    echo '	periodInterest = loanInterest/loanPeriods;';
    echo '	paymentsNumber = loanPeriods*loanLength;';
    echo '	paymentValue = Math.floor((loanAmount*periodInterest)/(1-Math.pow((1+periodInterest),(-1*paymentsNumber)))*100)/100;';
    echo '  if (!isNaN(paymentValue) && (paymentValue != Number.POSITIVE_INFINITY) && (paymentValue != Number.NEGATIVE_INFINITY)) {';
    echo '   document.madata.paymentNum.value = paymentsNumber;';
    echo '   document.madata.periodicalPayment.value = paymentValue;';
    echo '  } else {';
    echo '    document.madata.paymentNum.value = "";';
    echo '    document.madata.periodicalPayment.value = "";';
    echo '  }';
    echo '}';
		echo 'function clearText(field){';
		echo '	if (field.value == "%" || field.value == "$") {';
		echo '		field.value = "";';
		echo '	}';
		echo '}';
    echo '</script>';
		echo '</div>';
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		return $instance;
	}

	function form( $instance ) {
		$defaults = array( 'title' => __('Mortgage Calculator', 'macalc'));
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'hybrid'); ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" style="width:100%;" />
		</p>
	<?php
	}
}

?>